import 'package:dio/dio.dart';
import '../../core/config/api_endpoints.dart';
import '../../domain/interfaces/wallet_service_interface.dart';
import 'api/dio_client.dart';

class WalletService implements IWalletService {
  final DioClient dioClient;

  WalletService({required this.dioClient});

  @override
  Future<Response> getWallets() async => await dioClient.dio.get(
      ApiEndpoints.wallets,
    );

  @override
  Future<Response> addBalance({required String amount}) async => await dioClient.dio.post(
      ApiEndpoints.addBalance,
      data: {'amount': amount}
    );

  @override
  Future<Response> addCard({required Map<String, dynamic> body}) async => await dioClient.dio.post(
      ApiEndpoints.addCard,
      data: body
    );

  @override
  Future<Response> myCards() async => await dioClient.dio.get(
      ApiEndpoints.myCard,
    );

  @override
  Future<Response> deleteCard(String? id) async => await dioClient.dio.delete(
      '${ApiEndpoints.deleteCard}/$id',
    );

}
